#!/bin/sh

me="[$(printf $0 | xargs basename)]"

# Load OTP_Mainline.sh
. /opt/gira/bin/OTP_Mainline.sh

OCOTP_CFG_BANK=0
OCOTP_FUSE_WORD=5
OCOTP_LOCK_WORD=6

read_boot_fuses () {
  local boot_fuses=$(read_otp_single_value $OCOTP_CFG_BANK $OCOTP_FUSE_WORD)
  echo "${boot_fuses}"
}

read_lock () {
  local otp_lock=$(read_otp_single_value $OCOTP_CFG_BANK $OCOTP_LOCK_WORD)
  echo "${otp_lock}"
}

write_boot_fuses () {
  write_otp_single_value $OCOTP_CFG_BANK $OCOTP_FUSE_WORD $1
}

write_lock () {
  write_otp_single_value $OCOTP_CFG_BANK $OCOTP_LOCK_WORD $1
}
